package org.msh.reports.keys;

import org.msh.reports.variables.Variable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Store a sequence of keys
 * Created by rmemoria on 12/12/16.
 */
public class MultipleKeys extends Key {

    private List<Key> keys = new ArrayList<Key>();


    protected MultipleKeys() {
        super(null, null);
    }

    /**
     * Add a key to the list of keys
     * @param key
     */
    public void addKey(Key key) {
        keys.add(key);
    }

    /**
     * Return the list of keys
     * @return
     */
    public List<Key> getKeys() {
        return Collections.unmodifiableList(keys);
    }

    @Override
    public Object getValue() {
        throw new RuntimeException("Invalid call");
    }

    @Override
    public Object getGroup() {
        throw new RuntimeException("Invalid call");
    }

    @Override
    public void setVariable(Variable variable) {
        super.setVariable(variable);
        for (Key key: keys) {
            key.setVariable(variable);
        }
    }

    @Override
    public void setGroup(Object group) {
        super.setGroup(group);
        for (Key key: keys) {
            key.setGroup(group);
        }
    }
}
